//SDF's and combine methods from https://www.iquilezles.org/www/articles/distfunctions/distfunctions.htm

float opUnion(float d1 , float d2 ) {
    return min(d1, d2);
}

float opSubtraction( float d1, float d2 ) { 
    return max(-d1,d2); 
}

float opIntersection( float d1, float d2 ) { 
    return max(d1,d2); }

float opSmoothUnion(float d1 , float d2 , float k ) {
    float h = clamp(0.5 + 0.5 * (d2 - d1) / k, 0.0, 1.0);
    return mix(d2, d1, h) - k * h * (1.0 - h);
}

float opSmoothSubtraction(float d1 , float d2 , float k ) {
    float h = clamp(0.5 - 0.5 * (d2 + d1) / k, 0.0, 1.0);
    return mix(d2, -d1, h) + k * h * (1.0 - h);
}

float opSmoothIntersection(float d1 , float d2 , float k ) {
    float h = clamp(0.5 - 0.5 * (d2 - d1) / k, 0.0, 1.0);
    return mix(d2, d1, h) + k * h * (1.0 - h);
}


